/*  Ermittelt die resource_id der Kopfkostenstelle aus der gegebenen resource_id der zugehörigen Hauptressource.

    Als Language SQL implementiert, damit der Planer das SQL-Statement "inline" in die rufende SQL-Abfrage einfügen kann.
*/
SELECT tsystem.function__drop_by_regex( 'resource__top_resource_id__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource__top_resource_id__get(
    _resource_id integer
) RETURNS integer AS $$
    SELECT r_top.id AS _top_resource_id
    FROM scheduling.resource_requirement AS rr
    JOIN scheduling.resource_requirement_option AS rro ON rro.requirement_id = rr.id
    JOIN scheduling.resource AS r_top                  ON r_top.id = rro.resource_id
                                                      AND r_top.context = 'ksvba'
    JOIN ksvba AS ksb                                  ON ksb.ksb_id = r_top.context_id
                                                      AND ksb.ksb_ks_ba_num = 1 -- Nur der Arbeitsplatz mit der Nummer 1 wird von der Kopfkostenstelle verwendet.
    WHERE rr.required_by = _resource_id
      AND rr.context = 'ksvba'
$$ LANGUAGE sql STABLE PARALLEL SAFE;